CREATE TABLE cerberus.grants
(
    id            BIGSERIAL NOT NULL PRIMARY KEY,
    uid           BIGINT REFERENCES cerberus.users (uid) ON DELETE CASCADE,
    role_id       BIGINT REFERENCES cerberus.roles (id) ON DELETE CASCADE,
    group_id      BIGINT,
    group_type    TEXT,
    resource_type TEXT      NOT NULL REFERENCES cerberus.resource_type (name) ON DELETE CASCADE,
    resource_id   BIGINT,
    actions       TEXT[]    NOT NULL CHECK (cardinality(actions) > 0), -- granted actions

    CHECK ((uid IS NOT NULL AND role_id IS NULL AND group_id IS NULL AND group_type IS NULL) OR
           (uid IS NULL AND role_id IS NOT NULL AND group_id IS NULL AND group_type IS NULL) OR
           (uid IS NULL AND role_id IS NULL AND group_id IS NOT NULL AND group_type IS NOT NULL)),

    FOREIGN KEY (resource_type, resource_id) REFERENCES cerberus.resource (type, id) ON DELETE CASCADE,
    FOREIGN KEY (group_id, group_type) REFERENCES cerberus.groups (id, type) ON DELETE CASCADE
);
