CREATE OR REPLACE FUNCTION code.add_directory_events (
    i_user_id bigint,
    i_user_type collie.user_type,
    i_event_count bigint,
    i_event_type collie.event_type = 'organization_updated',
    i_event_revision bigint = 0
) RETURNS void AS $$
DECLARE
    inserted bigint;
    revision bigint;
BEGIN
   SELECT event_revision
      FROM collie.directory_events
      INTO revision
     WHERE user_id = i_user_id AND user_type = i_user_type
       FOR NO KEY UPDATE;

    IF NOT FOUND THEN
        INSERT INTO collie.directory_events
               (  user_id,   user_type, pending_events_count,  event_type,  event_revision)
        VALUES (i_user_id, i_user_type,        i_event_count, i_event_type, i_event_revision)
            ON CONFLICT DO NOTHING;

        GET DIAGNOSTICS inserted = ROW_COUNT;

        IF inserted = 1 THEN
            RETURN;
        END IF;

       SELECT event_revision
          FROM collie.directory_events
          INTO revision
         WHERE user_id = i_user_id AND user_type = i_user_type
           FOR NO KEY UPDATE;

        IF NOT FOUND THEN
            RAISE EXCEPTION 'User was unexpectedly deleted, user_id=%, user_type=%', user_id, user_type;
        END IF;
    END IF;
    
    IF revision is NULL OR i_event_revision >= revision THEN
        UPDATE collie.directory_events
           SET pending_events_count = pending_events_count + i_event_count,
               event_type = i_event_type,
               event_revision = i_event_revision
         WHERE user_id = i_user_id AND user_type = i_user_type;
    ELSE
        UPDATE collie.directory_events
           SET pending_events_count = pending_events_count + i_event_count
         WHERE user_id = i_user_id AND user_type = i_user_type;
    END IF;

    RETURN;
END
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.add_directory_event (
    i_user_id bigint,
    i_user_type collie.user_type,
    i_event_type collie.event_type = 'organization_updated',
    i_event_revision bigint = 0
) RETURNS void AS $$
BEGIN
    PERFORM code.add_directory_events(i_user_id, i_user_type, 1, i_event_type, i_event_revision);
END
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION code.add_directory_event (
    i_user_ids bigint[],
    i_user_type collie.user_type
) RETURNS void AS $$
BEGIN
    PERFORM code.add_directory_event(v_user_id, i_user_type) FROM unnest(i_user_ids) v_user_id;
END
$$ LANGUAGE plpgsql;
