CREATE SCHEMA IF NOT EXISTS collie;

CREATE TYPE collie.user_type AS ENUM (
    'passport_user',
    'passport_domain',
    'connect_organization'
);

CREATE TYPE collie.event_type AS ENUM (
    'organization_updated',
    'organization_deleted'
);

CREATE TABLE collie.directory_events (
    user_id bigint NOT NULL,
    user_type collie.user_type NOT NULL,
    pending_events_count bigint NOT NULL,
    synced_event_id bigint NOT NULL DEFAULT 0,
    last_sync_date timestamp with time zone NOT NULL DEFAULT current_timestamp,
    synced_revision bigint NOT NULL DEFAULT 0,
    event_type collie.event_type,
    event_revision bigint,

    CONSTRAINT pk_users PRIMARY KEY (user_id, user_type),
    CONSTRAINT check_pending_events_count CHECK (pending_events_count >= 0),
    CONSTRAINT check_synced_event_id CHECK (synced_event_id >= 0),
    CONSTRAINT check_synced_revision CHECK (synced_revision >= 0)
);

CREATE INDEX i_directory_events_by_pending_events_count
    ON collie.directory_events (user_type, pending_events_count);

CREATE INDEX i_directory_events_by_last_sync_date
    ON collie.directory_events (user_type, last_sync_date);

CREATE TYPE collie.service_type AS ENUM (
    'ml',
    'staff'
);

CREATE TABLE collie.service_sync (
    service_type collie.service_type NOT NULL,
    sync_timestamp timestamp with time zone NOT NULL DEFAULT current_timestamp,

    CONSTRAINT pk_service_sync PRIMARY KEY (service_type)
);

CREATE TABLE collie.staff_id_map (
    staff_id bigint NOT NULL,
    contact_id bigint NOT NULL,

    CONSTRAINT pk_staff_id_map PRIMARY KEY (staff_id)
);

CREATE TABLE collie.ml_id_map (
    ml_id bigint NOT NULL,
    contact_id bigint NOT NULL,

    CONSTRAINT pk_ml_id_map PRIMARY KEY (ml_id)
);
