CREATE SCHEMA IF NOT EXISTS collie;

CREATE TYPE collie.user_type AS ENUM (
    'passport_user',
    'passport_domain',
    'connect_organization'
);

CREATE TABLE collie.directory_events (
    user_id bigint NOT NULL,
    user_type collie.user_type NOT NULL,
    last_event_id bigint NOT NULL,
    pending_events_count bigint NOT NULL,
    synced_event_id bigint NOT NULL DEFAULT 0,
    last_sync_date timestamp with time zone NOT NULL DEFAULT current_timestamp,
    synced_revision bigint NOT NULL DEFAULT 0,

    CONSTRAINT pk_users PRIMARY KEY (user_id, user_type),
    CONSTRAINT check_last_event_id CHECK (last_event_id >= synced_event_id),
    CONSTRAINT check_pending_events_count CHECK (pending_events_count >= 0),
    CONSTRAINT check_synced_event_id CHECK (synced_event_id >= 0),
    CONSTRAINT check_synced_revision CHECK (synced_revision >= 0)
);

CREATE INDEX i_directory_events_by_pending_events_count
    ON collie.directory_events (user_id, user_type, pending_events_count);

CREATE INDEX i_directory_events_by_last_sync_date
    ON collie.directory_events (user_id, user_type, last_sync_date);
