CREATE TYPE collie.service_type AS ENUM (
    'ml',
    'staff'
);

CREATE TABLE collie.service_sync (
    service_type collie.service_type NOT NULL,
    sync_timestamp timestamp with time zone NOT NULL DEFAULT current_timestamp,

    CONSTRAINT pk_service_sync PRIMARY KEY (service_type)
);

CREATE TABLE collie.staff_id_map (
    staff_id bigint NOT NULL,
    contact_id bigint NOT NULL,

    CONSTRAINT pk_staff_id_map PRIMARY KEY (staff_id)
);

CREATE TABLE collie.ml_id_map (
    ml_id bigint NOT NULL,
    contact_id bigint NOT NULL,

    CONSTRAINT pk_ml_id_map PRIMARY KEY (ml_id)
);
