CREATE OR REPLACE FUNCTION code.set_domain_rules(
    i_request_info      code.request_info,
    i_rules             jsonb
) RETURNS integer AS $$
    INSERT INTO furita.domain_rules (org_id, rules)
    VALUES (i_request_info.org_id, i_rules)
        ON CONFLICT (org_id) DO UPDATE
       SET rules = i_rules, revision = furita.domain_rules.revision + 1, updated = current_timestamp
    RETURNING revision;
$$ LANGUAGE SQL;
