from mail.devpack.lib.components.postgres import Postgres


class FuritaDb(Postgres):
    NAME = "furitadb"

    before_all_prefixes = [
        'resfs/file/mail/pg/furitadb/drop',
    ]

    after_all_prefixes = [
        'resfs/file/mail/pg/furitadb/code',
        'resfs/file/mail/pg/furitadb/grants',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/furitadb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/furitadb/furita.sql',
    ]

    def __init__(self, env, _):
        users = [
            'furitadb',
            'furita',
            'tech',
        ]
        self.init_from_conf(env.get_config(), 'furitadb', users)
