CREATE SCHEMA buckets;

CREATE TABLE buckets.workers (
    worker_id   serial primary key,
    worker      text unique,
    heartbeated timestamptz
);

CREATE TABLE buckets.buckets (
    bucket_id  text primary key,
    worker     text,
    heartbeat  timestamptz,
    last_updated timestamptz default now()
);

CREATE TABLE buckets.workload (
    shard_id            integer NOT NULL PRIMARY KEY REFERENCES shiva.shards (shard_id) ON DELETE CASCADE,
    max_workers         integer NOT NULL
);

CREATE TYPE bucket_id_type AS (
    shard_id   integer,
    husky_cluster text
);
