CREATE OR REPLACE FUNCTION code.get_blocking_tasks(
    i_task transfer.task
) RETURNS transfer.task[] AS $$
    SELECT blocker FROM (
        SELECT dependent::transfer.task, blocker::transfer.task[]
          FROM (VALUES
                ('transfer', array['apply_data_migrations', 'clone_user', 'delete_mail_user']),
                ('clone_user', array['apply_data_migrations']),
                ('apply_data_migrations', NULL),
                ('delete_mail_user', array['delete_shards_user'])
        ) AS v(dependent, blocker)
   ) deps WHERE dependent = i_task;
$$ LANGUAGE SQL IMMUTABLE;
