from mail.devpack.lib.components.postgres import Postgres
from mail.devpack.lib.components.sharddb import ShardDb


class HuskyDb(Postgres):
    NAME = "huskydb"
    DEPS = [ShardDb]

    before_all_prefixes = [
        'resfs/file/mail/pg/huskydb/devpack/extensions.sql',
    ]
    after_all_prefixes = [
        'resfs/file/mail/pg/huskydb/code',
        'resfs/file/mail/pg/huskydb/grants',
        'resfs/file/mail/devpack/sql',
        'resfs/file/mail/pg/huskydb/devpack/grants.sql',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/huskydb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/huskydb/huskydb.sql',
        'resfs/file/mail/pg/huskydb/samsara.sql',
        'resfs/file/mail/pg/huskydb/shiva.sql',
        'resfs/file/mail/pg/huskydb/buckets.sql',  # buckets.sql depends on shiva.sql so it follows the latter
    ]

    def __init__(self, env, components):
        users = [
            'husky',
            'samsara',
            'sharpei',
            'shiva',
        ]
        self.sharddb = components[ShardDb]
        self.init_from_conf(
            env.get_config(), 'huskydb', users,
            self.before_all_prefixes + self.snapshot_sql_files + self.after_all_prefixes
        )
        self.huskies = {
            42: 'husky',
            99: 'husky2',
            666: 'forever_sleeping',
        }

    def prepare_data(self):
        super(HuskyDb, self).prepare_data()
        shard_ids = [(row[0], row[1]) for row in self.sharddb.query('SELECT shard_id, name FROM shards.shards')]
        for shard_id, shard_name in shard_ids:
            self.execute(
                '''
                    INSERT INTO shiva.shards (shard_id, shard_name, cluster_id, migration, disk_size, can_transfer_to)
                    VALUES (%(shard_id)s, %(shard_name)s, %(cluster_id)s, %(migration)s, %(disk_size)s, %(can_transfer_to)s)
                ''',
                shard_id=shard_id,
                shard_name=shard_name,
                cluster_id='cid_for_shard_id_{}'.format(shard_id),
                # TODO :: Actually migrate with pgmigrate or set proper migration number
                migration=1,
                disk_size=0,
                can_transfer_to=True,
            )
