DROP INDEX transfer.i_users_in_dogsleds_by_husky_id_status_prioretized;

CREATE INDEX i_users_in_dogsleds_for_husky_prioritized
    ON transfer.users_in_dogsleds (husky_id, status, priority, last_update)
 WHERE husky_id IS NOT NULL;

COMMENT ON INDEX transfer.i_users_in_dogsleds_for_husky_prioritized
    IS 'Works as prioritized queue for huskies';


CREATE INDEX i_users_in_dogsleds_for_yaqt_prioritized
    ON transfer.users_in_dogsleds (priority, last_update, transfer_id)
 WHERE husky_id IS NULL
   AND status IN ('userinfo_unfilled', 'pending');

COMMENT ON INDEX transfer.i_users_in_dogsleds_for_yaqt_prioritized
    IS 'Works as prioritized queue for yaqt, with transfer_id '
       'for cases with many tasks with same priority and last_update';


CREATE TABLE transfer.yaqts_in_chum (
    yaqt_id   serial,
    yaqt_host text NOT NULL,
    is_residential boolean NOT NULL DEFAULT TRUE,

    CONSTRAINT pk_yaqts PRIMARY KEY(yaqt_id)
);

CREATE UNIQUE INDEX i_yaqt_chums_unique_hosts
    ON transfer.yaqts_in_chum(yaqt_host);

CREATE UNIQUE INDEX i_yaqt_chums_single_row
    ON transfer.yaqts_in_chum(is_residential)
 WHERE is_residential = true;

COMMENT ON INDEX transfer.i_yaqt_chums_single_row
    IS 'Since yaqt serivce is not distributed, you can have only one instance running';
