DELETE FROM transfer.users_in_dogsleds
 WHERE husky_id IS NULL
   AND task <> 'transfer'::transfer.task;

ALTER TABLE transfer.users_in_dogsleds
    ADD COLUMN loaded_shard text,
    ADD CONSTRAINT check_loaded_shard CHECK (
        -- Task is in concrete Husky
        husky_id IS NOT NULL
        -- Loaded shard is deducable from task_args
        OR task = 'transfer'::transfer.task
        -- Loaded shard is set explicitly
        OR loaded_shard IS NOT NULL
    );

COMMENT ON CONSTRAINT check_loaded_shard
     ON transfer.users_in_dogsleds
     IS 'Set loaded_shard explicitly for non-transfer tasks in Yaqt';