CREATE TABLE transfer.shards_in_dogsleds (
    shard_task_id bigserial,
    task          transfer.task NOT NULL,
    task_args     jsonb,
    shard_name    text NOT NULL,
    priority      smallint NOT NULL DEFAULT 0,

    CONSTRAINT pk_shards_in_dogsleds PRIMARY KEY (shard_task_id),
    CONSTRAINT unique_shard_task UNIQUE (task, task_args, shard_name)
);

CREATE TABLE transfer.batches_in_dogsleds (
    batch_task_id bigserial,
    task          transfer.task NOT NULL,
    task_args     jsonb,
    uids          bigint[] NOT NULL,
    loaded_shard  text NOT NULL,
    priority      smallint NOT NULL DEFAULT 0,

    CONSTRAINT pk_batches_in_dogsleds PRIMARY KEY (batch_task_id)
);

CREATE INDEX i_batches_in_dogsleds_by_loaded_shard_prioritized
  ON transfer.batches_in_dogsleds (loaded_shard, priority, batch_task_id);