ALTER TABLE transfer.users_in_dogsleds
    DROP CONSTRAINT IF EXISTS check_loaded_shard;

ALTER TABLE transfer.users_in_dogsleds
    ADD CONSTRAINT check_loaded_shard CHECK (
        -- Task is in concrete Husky
        husky_id IS NOT NULL
        -- Loaded shard is deducable from task_args
        OR task = ANY(ARRAY[
            'transfer'::transfer.task,
            'duplicate_mailing_list'::transfer.task,
            'duplicate_mailing_list_copy_user'::transfer.task
        ])
        -- Loaded shard is set explicitly
        OR loaded_shard IS NOT NULL
    );

COMMENT ON CONSTRAINT check_loaded_shard
     ON transfer.users_in_dogsleds
     IS 'Set loaded_shard explicitly for non-transfer and non-duplicate_mailing_list tasks in Yaqt';

ALTER TABLE transfer.users_in_dogsleds
    ADD COLUMN task_output jsonb;

CREATE TABLE transfer.delayed_users_tasks (
    transfer_id  integer NOT NULL,
    delayed_until timestamp with time zone NOT NULL,

    CONSTRAINT pk_delayed_users_tasks
        PRIMARY KEY (transfer_id),
    CONSTRAINT fk_users_in_dogsleds_and_delayed_users_tasks
        FOREIGN KEY (transfer_id) REFERENCES transfer.users_in_dogsleds ON DELETE CASCADE
);

CREATE INDEX i_delayed_users_tasks_delayed_until
    ON transfer.delayed_users_tasks (delayed_until);
