CREATE TABLE transfer.repeatable_users_tasks (
    transfer_id integer NOT NULL,
    crontab     text NOT NULL,

    CONSTRAINT pk_repeatable_users_tasks
        PRIMARY KEY (transfer_id),
    CONSTRAINT fk_users_in_dogsleds_and_repeatable_users_tasks
        FOREIGN KEY (transfer_id) REFERENCES transfer.users_in_dogsleds ON DELETE CASCADE,
    CONSTRAINT check_users_in_dogsleds_crontab CHECK (
        crontab ~ '^[^ ]+( +[^ ]+){4,5}$'
    )
);

COMMENT ON COLUMN transfer.repeatable_users_tasks.crontab
    IS 'Format: <Minute> <Hour> <Day_of_the_Month> <Month_of_the_Year> <Day_of_the_Week>[ <Year>]';

ALTER TABLE transfer.users_in_dogsleds
    ADD COLUMN parent_transfer_id integer;

ALTER TABLE transfer.users_in_dogsleds
    ADD CONSTRAINT fk_users_in_dogsleds_parent_transfer_id
        FOREIGN KEY (parent_transfer_id) REFERENCES transfer.users_in_dogsleds (transfer_id) ON DELETE RESTRICT;

DROP INDEX IF EXISTS transfer.i_users_in_dogsleds_by_uid_not_null_not_processed;

CREATE UNIQUE INDEX i_users_in_dogsleds_by_uid_not_null_not_processed
    ON transfer.users_in_dogsleds (uid, task, status)
 WHERE uid IS NOT NULL
   AND status IN (
    'pending'::transfer.task_status,
    'delayed'::transfer.task_status,
    'repeatable'::transfer.task_status
);
