ALTER TABLE transfer.users_in_dogsleds
    DROP CONSTRAINT IF EXISTS check_loaded_shard;

ALTER TABLE transfer.users_in_dogsleds
    ADD CONSTRAINT check_loaded_shard CHECK (
        -- Task is in concrete Husky
        husky_id IS NOT NULL
        -- Loaded shard is set explicitly
        OR loaded_shard IS NOT NULL
        -- Loaded shard is deducible from task_args
        OR task = ANY(ARRAY[
            'transfer'::transfer.task,
            'transfer_subscriber'::transfer.task,
            'duplicate_mailing_list'::transfer.task,
            'duplicate_mailing_list_copy_user'::transfer.task
        ])
    );

COMMENT ON CONSTRAINT check_loaded_shard
     ON transfer.users_in_dogsleds
     IS 'Set loaded_shard explicitly for non-transfer and non-duplicate tasks in Yaqt';
