ALTER TABLE transfer.users_in_dogsleds DROP CONSTRAINT IF EXISTS check_loaded_shard;

DROP INDEX IF EXISTS transfer.i_users_in_dogsleds_by_uid_not_null_not_processed;

CREATE UNIQUE INDEX i_users_in_dogsleds_by_uid_not_null_not_processed
    ON transfer.users_in_dogsleds (uid, task, status)
 WHERE uid IS NOT NULL
   AND status NOT IN (
    'complete'::transfer.task_status,
    'error'::transfer.task_status
);

CREATE INDEX i_users_in_dogsleds_by_parent_transfer_id
    ON transfer.users_in_dogsleds (parent_transfer_id);
