CREATE SCHEMA IF NOT EXISTS shiva;

CREATE TYPE shiva.shard_types AS ENUM (
    'canary',
    'canary2',
    'qa',
    'general'
);

CREATE TABLE shiva.shards (
    shard_id            integer NOT NULL,
    cluster_id          TEXT NOT NULL,
    shard_type          shiva.shard_types NOT NULL DEFAULT 'general',
    migration           integer NOT NULL,
    priority            integer NOT NULL DEFAULT 0,

    CONSTRAINT pk_shards PRIMARY KEY (shard_id)
);

CREATE UNIQUE INDEX uk_shards_cluster_id
    ON shiva.shards (cluster_id);

CREATE INDEX i_shards_shard_type ON shiva.shards (shard_type);


CREATE TYPE shiva.status AS ENUM (
    'pending',
    'in_progress',
    'complete',
    'error'
);

CREATE TABLE shiva.migrations (
    migration_id         SERIAL PRIMARY KEY,
    migration            integer NOT NULL,
    migration_args       jsonb,
    status               shiva.status NOT NULL DEFAULT 'in_progress'
);

CREATE UNIQUE INDEX i_migrations_by_status_not_processed
    ON shiva.migrations (status)
 WHERE status NOT IN ('complete', 'error');


CREATE TABLE shiva.migrations_info (
    migration_id         integer NOT NULL,
    shard_id             integer NOT NULL,
    prev_migration       integer NOT NULL,
    status               shiva.status NOT NULL DEFAULT 'pending',
    notice               TEXT,
    migrate_log          TEXT,

    CONSTRAINT pk_migrations_info PRIMARY KEY (migration_id, shard_id),

    CONSTRAINT fk_migrations_and_migrations_info
        FOREIGN KEY (migration_id) REFERENCES shiva.migrations ON DELETE CASCADE
);
