CREATE TYPE shiva.task_types AS ENUM (
    'cleanup_doomed',
    'end_prepared_transaction',
    'folder_archivation',
    'init_pop3_folders',
    'pg_partman_maintenance',
    'purge_chained_log',
    'purge_deleted_box',
    'purge_storage',
    'purge_user',
    'space_balancer',
    'update_mailbox_size',
    'settings_export',
    'huskydb_pg_partman_maintenance'
);

CREATE TABLE shiva.shard_running_tasks (
    shard_id            integer NOT NULL,
    task                shiva.task_types NOT NULL,
    job_no              integer NOT NULL,
    started             timestamp with time zone NOT NULL DEFAULT current_timestamp,
    worker              TEXT NOT NULL,

    CONSTRAINT pk_running_tasks PRIMARY KEY (shard_id, task, job_no)
);

CREATE INDEX i_running_tasks_by_worker
    ON shiva.shard_running_tasks (worker);


CREATE TABLE shiva.shard_tasks_info (
    shard_id            integer NOT NULL,
    task                shiva.task_types NOT NULL,
    job_no              integer NOT NULL,
    started             timestamp with time zone NOT NULL,
    finished            timestamp with time zone NOT NULL DEFAULT current_timestamp,
    worker              TEXT NOT NULL,
    status              shiva.status NOT NULL,
    notice              TEXT
) PARTITION BY RANGE (finished);

CREATE TABLE shiva.shard_tasks_info_templ (
    LIKE shiva.shard_tasks_info INCLUDING DEFAULTS
);

ALTER TABLE shiva.shard_tasks_info_templ
    ADD CONSTRAINT pk_shard_tasks_info_templ PRIMARY KEY (shard_id, task, job_no, started, finished);

CREATE INDEX i_shard_tasks_info_by_status_task_worker_templ
    ON shiva.shard_tasks_info_templ (status, task, worker);

SELECT create_parent(
    p_parent_table := 'shiva.shard_tasks_info',
    p_template_table := 'shiva.shard_tasks_info_templ',
    p_control := 'finished',
    p_type := 'native',
    p_interval := 'daily',
    p_premake := 5,
    p_jobmon := false
);
UPDATE part_config
   SET retention = '7 days',
       retention_keep_table = false,
       retention_keep_index = false
 WHERE parent_table = 'shiva.shard_tasks_info';
