CREATE TABLE transfer.processed_tasks (
    transfer_id bigint,
    uid         bigint,
    login       text,
    priority    smallint,
    husky_id    integer,
    tries       smallint,
    task        transfer.task,
    task_args   jsonb,
    status      transfer.task_status,
    error_type  transfer.error,
    last_update timestamp with time zone,
    try_notices text[],
    loaded_shard text,
    task_output jsonb,
    shard_id    integer
) PARTITION BY RANGE (last_update);

CREATE TABLE transfer.processed_tasks_templ (
    LIKE transfer.processed_tasks INCLUDING DEFAULTS
);

ALTER TABLE transfer.processed_tasks_templ
    ADD CONSTRAINT pk_processed_tasks_templ PRIMARY KEY (transfer_id);

CREATE INDEX i_processed_tasks_by_uid_templ
    ON transfer.processed_tasks_templ (uid);
    
CREATE INDEX i_processed_tasks_by_task_and_shard_id_templ
    ON transfer.processed_tasks_templ (task, shard_id, task_args);
   
SELECT create_parent(
    p_parent_table := 'transfer.processed_tasks',
    p_template_table := 'transfer.processed_tasks_templ',
    p_control := 'last_update',
    p_type := 'native',
    p_interval := 'daily',
    p_premake := 5,
    p_jobmon := false
);
UPDATE part_config
   SET retention = '60 days',
       retention_keep_table = false,
       retention_keep_index = false
 WHERE parent_table = 'transfer.processed_tasks';
