CREATE TABLE transfer.task_group (
    id            serial PRIMARY KEY,
    name          text NOT NULL,
    husky_cluster text NOT NULL
);

CREATE INDEX i_task_group_by_husky_cluster
    ON transfer.task_group (husky_cluster);

CREATE TYPE bucket_id_type AS (
    shard_id   integer,
    husky_cluster text
);

ALTER TABLE transfer.users_in_dogsleds
    ADD COLUMN task_group_id integer REFERENCES transfer.task_group (id);

ALTER TABLE buckets.buckets DROP CONSTRAINT buckets_pkey;
ALTER TABLE buckets.buckets RENAME COLUMN bucket_id TO bucket_id_old;
ALTER TABLE buckets.buckets ADD COLUMN bucket_id text;
UPDATE buckets.buckets SET bucket_id = (bucket_id_old, NULL);
ALTER TABLE buckets.buckets DROP COLUMN bucket_id_old;
ALTER TABLE buckets.buckets ADD CONSTRAINT buckets_pkey PRIMARY KEY (bucket_id);

-- recreate the rest of the columns to preserve column order and comply with test_migrations.py::test_migrations
ALTER TABLE buckets.buckets RENAME COLUMN worker TO worker_old;
ALTER TABLE buckets.buckets ADD COLUMN worker text;
UPDATE buckets.buckets SET worker = worker_old;
ALTER TABLE buckets.buckets DROP COLUMN worker_old;

ALTER TABLE buckets.buckets RENAME COLUMN heartbeat TO heartbeat_old;
ALTER TABLE buckets.buckets ADD COLUMN heartbeat timestamptz;
UPDATE buckets.buckets SET heartbeat = heartbeat_old;
ALTER TABLE buckets.buckets DROP COLUMN heartbeat_old;

ALTER TABLE buckets.buckets RENAME COLUMN last_updated TO last_updated_old;
ALTER TABLE buckets.buckets ADD COLUMN last_updated timestamptz default now();
UPDATE buckets.buckets SET last_updated = last_updated_old;
ALTER TABLE buckets.buckets DROP COLUMN last_updated_old;
