CREATE OR REPLACE FUNCTION code.reserve_backup_id(
    i_uid             code.uid,
    i_request_info    code.request_info DEFAULT NULL
) RETURNS integer AS $$
DECLARE
    current_backup_id integer := (impl.acquire_current_serials(i_uid)).next_backup_id;
BEGIN
    UPDATE mail.serials
       SET next_backup_id = next_backup_id + 1
     WHERE uid = i_uid;
    RETURN current_backup_id;
END;
$$ LANGUAGE plpgsql;
