CREATE OR REPLACE FUNCTION code.create_restore(
    i_uid             code.uid,
    i_backup_id       integer,
    i_now             timestamptz,
    i_method          backup.restore_method,
    i_mapping         backup.fid_to_fid[],
    i_request_info    code.request_info DEFAULT NULL
) RETURNS text AS $$
DECLARE
    current_state backup.backup_state;
    running_backup boolean;
    messages      integer;
BEGIN
    PERFORM code.acquire_current_revision(i_uid);

    SELECT state
      FROM backup.backups
     WHERE uid = i_uid AND backup_id = i_backup_id
      INTO current_state;

    IF current_state IS NULL THEN
        RETURN 'backup_is_missing';
    ELSIF current_state != 'complete' THEN
        RETURN 'wrong_state';
    END IF;

    SELECT true
      FROM backup.backups
     WHERE uid = i_uid AND backup_id != i_backup_id AND state = 'in_progress'
      INTO running_backup;

    IF COALESCE(running_backup, false) THEN
        RETURN 'another_backup_in_running';
    END IF;


    SELECT count(*)
      FROM backup.box AS bb
      LEFT JOIN mail.box AS mb
        ON bb.uid = mb.uid AND bb.mid = mb.mid
     WHERE bb.uid = i_uid AND bb.backup_id = i_backup_id
       AND mb.uid IS NULL AND mb.mid IS NULL
      INTO messages;

    INSERT INTO backup.restores(uid, backup_id, created, updated, to_restore_count, method, fids_mapping)
    VALUES (i_uid, i_backup_id, i_now, i_now, messages, i_method, i_mapping)
        ON CONFLICT DO NOTHING;

    IF NOT FOUND THEN
        RETURN 'unique_violation';
    END IF;

    RETURN NULL;
END;
$$ LANGUAGE plpgsql;
