CREATE OR REPLACE FUNCTION code.restore_update_mids(
    i_uid             code.uid,
    i_backup_id       integer,
    i_mapping         backup.mid_to_mid[],
    i_request_info    code.request_info DEFAULT NULL
) RETURNS void AS $$
DECLARE
    messages      integer;
BEGIN
    PERFORM code.acquire_current_revision(i_uid);

    WITH updated AS (
        UPDATE backup.box AS bb
           SET mid = mids.renewed
          FROM unnest(i_mapping) AS mids
         WHERE bb.uid = i_uid AND bb.backup_id = i_backup_id AND bb.mid = mids.original
     RETURNING 1
    )
    SELECT count(*)
      FROM updated
      INTO messages;

    PERFORM code.purge_deleted_messages(
        i_uid,
        ARRAY(SELECT original FROM unnest(i_mapping))
    );

    UPDATE backup.restores AS r
       SET updated = current_timestamp,
           restored_count = r.restored_count + messages
     WHERE uid = i_uid AND state = 'in_progress';
END;
$$ LANGUAGE plpgsql;
