CREATE OR REPLACE FUNCTION code.update_backup_settings(
    i_uid        code.uid,
    i_settings   backup.settings,
    i_request_info    code.request_info DEFAULT NULL
) RETURNS backup.settings AS $$
DECLARE
    v_fids          integer[] := i_settings.fids;
    v_tabs          mail.tab_types[] := i_settings.tabs;
    v_inbox_fid     integer := code.get_folder_fid(i_uid, 'inbox');
    v_relevant_tab  mail.tab_types := 'relevant'::mail.tab_types;
BEGIN
    PERFORM code.acquire_current_revision(i_uid);

    -- Check for inbox and relevant tab - they are equal to user
    -- So there is following logic:
    -- 1. If inbox is backuped, relevant tab must be too
    IF v_fids && array[v_inbox_fid] THEN
        v_tabs := v_tabs || v_relevant_tab;
    END IF;

    -- 2. If relevant tab is backuped, inbox must be too
    IF v_tabs && array[v_relevant_tab] THEN
        v_fids := v_fids || v_inbox_fid;
    END IF;

    -- Deleting unnecessary fids from settings
    DELETE FROM backup.folders_to_backup
     WHERE uid = i_uid
       AND fid != ALL(v_fids);

    -- Set necessary fids to settings
    INSERT INTO backup.folders_to_backup (uid, fid)
    SELECT i_uid, fid
      FROM unnest(v_fids) AS fid
        ON CONFLICT DO NOTHING;

    -- Deleting unnecessary tabs from settings
    DELETE FROM backup.tabs_to_backup
     WHERE uid = i_uid
       AND tab != ALL(v_tabs);

    -- Set necessary tabs to settings
    INSERT INTO backup.tabs_to_backup (uid, tab)
    SELECT i_uid, tab
      FROM unnest(v_tabs) AS tab
        ON CONFLICT DO NOTHING;

    -- Return result settings
    RETURN (
        COALESCE((
          SELECT array_agg(fid)
            FROM backup.folders_to_backup
           WHERE uid = i_uid
        )::integer[], '{}'::integer[]),
        COALESCE((
          SELECT array_agg(tab)
            FROM backup.tabs_to_backup
           WHERE uid = i_uid
        )::mail.tab_types[], '{}'::mail.tab_types[])
    )::backup.settings;

END;
$$ LANGUAGE plpgsql;
