CREATE OR REPLACE FUNCTION code.complete_restore(
    i_uid             code.uid,
    i_request_info    code.request_info DEFAULT NULL
) RETURNS void AS $$
BEGIN
    PERFORM code.acquire_current_revision(i_uid);

    UPDATE backup.restores
       SET updated = current_timestamp,
           state = 'complete'
     WHERE uid = i_uid AND state = 'in_progress';
END;
$$ LANGUAGE plpgsql;
