CREATE OR REPLACE FUNCTION code.fail_backup(
    i_uid             code.uid,
    i_notice          text,
    i_request_info    code.request_info DEFAULT NULL
) RETURNS void AS $$
BEGIN
    PERFORM code.acquire_current_revision(i_uid);

    UPDATE backup.backups
       SET updated = current_timestamp,
           state = 'error',
           notice = i_notice
     WHERE uid = i_uid AND state = 'in_progress';
END;
$$ LANGUAGE plpgsql;
