CREATE OR REPLACE FUNCTION code.deactivate_backup(
    i_uid             code.uid,
    i_request_info    code.request_info DEFAULT NULL
) RETURNS text AS $$
DECLARE
    running_restore boolean;
BEGIN
    PERFORM code.acquire_current_revision(i_uid);

    SELECT true
      FROM backup.restores
     WHERE uid = i_uid AND state = 'in_progress'
      INTO running_restore;

    IF running_restore THEN
        RETURN 'restore_in_progress';
    END IF;

    UPDATE backup.backups
       SET updated = current_timestamp,
           state = 'inactive'
     WHERE uid = i_uid AND state = 'complete';

    IF NOT FOUND THEN
        RETURN 'missing_complete_backup';
    END IF;

    RETURN NULL;
END;
$$ LANGUAGE plpgsql;
