
CREATE DOMAIN code.uid AS bigint
    CONSTRAINT uid_not_null_and_positive
        CHECK (VALUE IS NOT NULL AND VALUE > 0);

CREATE DOMAIN code.fid AS integer
    CONSTRAINT fid_not_null_and_positive
        CHECK (VALUE IS NOT NULL AND VALUE > 0);

CREATE DOMAIN code.fids AS integer[]
    CONSTRAINT fids_not_null_and_not_empty
        CHECK (
            VALUE IS NOT NULL
            AND
            cardinality(VALUE) > 0
        );

CREATE DOMAIN code.mid AS bigint
    CONSTRAINT mid_not_null_and_positive
        CHECK (VALUE IS NOT NULL AND VALUE > 0);

CREATE DOMAIN code.mids AS bigint[]
    CONSTRAINT mids_not_empty
        CHECK (
            VALUE IS NOT NULL
            AND
            cardinality(VALUE) > 0
        );

CREATE DOMAIN code.tid AS bigint
    CONSTRAINT tid_is_not_null_and_positive
        CHECK (VALUE IS NOT NULL AND VALUE > 0);

CREATE DOMAIN code.tids AS bigint[]
    CONSTRAINT tids_not_empty
        CHECK (
            VALUE IS NOT NULL
            AND
            cardinality(VALUE) > 0
        );

CREATE DOMAIN code.lid AS integer
    CONSTRAINT lid_is_not_null_and_positive
        CHECK (VALUE IS NOT NULL AND VALUE > 0);

CREATE DOMAIN code.lids AS integer[]
    CONSTRAINT lids_not_empty
        CHECK (
            VALUE IS NOT NULL
            AND
            cardinality(VALUE) > 0
        );

CREATE DOMAIN code.unique_lids AS integer[]
    CONSTRAINT lids_unique
         CHECK (
            uniq(sort(VALUE)) = sort(VALUE) -- intarray functions
        );

CREATE DOMAIN code.hid AS text
    CONSTRAINT hid_is_not_null
        CHECK (VALUE IS NOT NULL);

CREATE DOMAIN code.subscription_id AS bigint
   CONSTRAINT subscription_id_not_null_and_positive
        CHECK (
            VALUE IS NOT NULL
            AND
            VALUE > 0
        );

CREATE DOMAIN code.subscription_ids AS bigint[]
    CONSTRAINT subscription_ids_not_null_and_not_empty
        CHECK (
            VALUE IS NOT NULL
            AND
            cardinality(VALUE) > 0
        );

CREATE DOMAIN code.worker_id AS text
   CONSTRAINT subscription_id_not_null_and_positive
        CHECK (
            VALUE IS NOT NULL
            AND
            length(VALUE) > 0
        );

CREATE DOMAIN code.subscriptions_limit AS bigint
    CONSTRAINT subscription_limit_not_null_and_positive
        CHECK (
            VALUE IS NOT NULL
            AND
            VALUE > 0
        );

CREATE DOMAIN code.defined_timestamp AS timestamp with time zone
    CONSTRAINT define_timestamp_not_null
        CHECK (VALUE IS NOT NULL);

CREATE DOMAIN code.collector_id AS integer
    CONSTRAINT collector_id_null_and_positive
        CHECK (VALUE IS NOT NULL AND VALUE > 0);
