
CREATE TYPE code.hdr_date_and_message_id AS (
    hdr_date       bigint,
    hdr_message_id text
);

CREATE TYPE code.thread_info AS (
    tid           bigint,
    message_count integer
);

CREATE TYPE code.attaches_info AS (
    attach_count smallint,
    attach_size  integer
);

-- store_mail in types
-- pop_uidl - MAILPG-60
CREATE TYPE code.store_coordinates AS (
    fid           integer,
    tid           bigint,
    seen          boolean,
    deleted       boolean,
    st_id         text,
    received_date timestamp with time zone,
    size          integer,
    attributes    mail.message_attributes[],
    pop_uidl      text
);

CREATE TYPE code.store_coordinates_with_tab AS (
    fid           integer,
    tid           bigint,
    seen          boolean,
    deleted       boolean,
    st_id         text,
    received_date timestamp with time zone,
    size          integer,
    attributes    mail.message_attributes[],
    pop_uidl      text,
    tab           mail.tab_types
);


CREATE TYPE code.owner_coordinates AS (
    uid      bigint,
    fid      integer,
    mid      bigint,
    tid      bigint,
    revision bigint
);

CREATE TYPE code.sync_coordinates AS (
    seen          boolean,
    deleted       boolean,
    st_id         text,
    received_date timestamp with time zone,
    size          integer,
    attributes    mail.message_attributes[]
);

CREATE TYPE code.store_deleted_coordinates AS (
    st_id         text,
    received_date timestamp with time zone,
    size          integer,
    attributes    mail.message_attributes[]
);

-- remove sort_options - MAILPG-311
CREATE TYPE code.store_threading AS (
    rule              mail.threads_merge_rules,
    references_hashes numeric[],
    in_reply_to_hash  numeric,
    hash_value        numeric,
    hash_namespace    mail.thread_hash_namespaces,
    hash_uniq_key     bigint,
    sort_options      text
);

CREATE TYPE code.sync_threading AS (
    references_hashes numeric[],
    in_reply_to_hash  numeric
);


-- remove extra_data - MAILPG-313
CREATE TYPE code.store_headers AS (
    subject         text,
    firstline       text,
    hdr_date        timestamp with time zone,
    hdr_message_id  text,
    extra_data      text
);

CREATE TYPE code.sync_headers AS (
    subject         text,
    firstline       text,
    hdr_date        timestamp with time zone,
    hdr_message_id  text
);


CREATE TYPE code.store_attach AS (
    hid      text,
    type     text,
    filename text,
    size     integer
);

CREATE TYPE code.sync_attach AS (
    hid        text,
    type       text,
    filename   text,
    size       integer
);

CREATE TYPE code.store_mime_part AS (
    hid                 text,
    content_type        text,
    content_subtype     text,
    boundary            text,
    name                text,
    charset             text,
    encoding            text,
    content_disposition text,
    filename            text,
    cid                 text,

    offset_begin        integer,
    offset_end          integer
);

CREATE CAST (code.store_mime_part[] AS mail.mime_part[]) WITH INOUT;

CREATE TYPE code.sync_mime_part AS (
    hid                 text,
    content_type        text,
    content_subtype     text,
    boundary            text,
    name                text,
    charset             text,
    encoding            text,
    content_disposition text,
    filename            text,
    cid                 text,

    offset_begin        integer,
    offset_end          integer
);

CREATE CAST (code.sync_mime_part[] AS mail.mime_part[]) WITH INOUT;

CREATE TYPE code.store_recipient AS (
    type  mail.recipient_type,
    name  text,
    email text
);

CREATE TYPE code.sync_recipient AS (
    type  mail.recipient_type,
    name  text,
    email text
);

CREATE TYPE code.store_result AS (
    mid      bigint,
    tid      bigint,
    imap_id  bigint,
    revision bigint
);

CREATE TYPE code.sync_result AS (
    mid            bigint,
    revision       bigint,
    owner_mid      bigint,
    owner_revision bigint
);

CREATE TYPE code.store_deleted_result AS (
    mid      bigint,
    revision bigint
);

CREATE CAST (impl.store_deleted_result AS code.store_deleted_result) WITH INOUT;

-- -------------------------------------------------------

-- ------------ quick_save_message types -----------------

CREATE TYPE code.quick_save_coordinates AS (
    st_id         text,
    received_date timestamp with time zone,
    size          integer,
    attributes    mail.message_attributes[],
    pop_uidl      text
);

CREATE TYPE code.quick_save_headers AS (
    firstline       text,
    hdr_date        timestamp with time zone,
    hdr_message_id  text
);

CREATE TYPE code.quick_save_result AS (
    updated  boolean,
    revision bigint
);
-- -------------------------------------------------------

CREATE TYPE code.label_key AS (
    name text,
    type mail.labels_types
);

CREATE TYPE code.label_def AS (
    name    text,
    type    mail.labels_types,
    color   text,
    created timestamp with time zone
);

CREATE TYPE code.label_info AS (
    lid           integer,
    name          text,
    type          mail.labels_types,
    message_count integer,
    color         text,
    created       timestamp with time zone,
    revision      bigint
);

CREATE TYPE code.operation_result AS (
    revision bigint,
    mids     bigint[]
);

CREATE TYPE code.chained_message AS (
    chained_id bigint,
    diststance smallint
);

CREATE TYPE code.request_info AS (
    x_request_id    text,
    session_key     text
);

CREATE CAST (code.request_info AS impl.request_info) WITH INOUT AS IMPLICIT;

CREATE TYPE code.check_record AS (
    name   text,
    broken json
);

CREATE TYPE code.registration_result AS ENUM (
    'success',
    'already_registered',
    'already_in_progress',
    'shard_is_occupied_by_user'
);

CREATE TYPE code.purged_message AS (
    mid          code.mid,
    recipients   jsonb,
    size         integer,
    deleted_info jsonb
);

CREATE TYPE code.default_serials AS (
    next_revision        bigint,
    next_fid             bigint,
    next_lid             integer,
    next_mid_serial      bigint,
    next_owner_subscription_id      bigint,
    next_subscriber_subscription_id bigint,
    next_collector_id    integer,
    next_backup_id       integer
);

CREATE TYPE code.subscription_action AS ENUM (
    'initialization',
    'synchronization',
    'migration',
    'unsubscription',
    'termination',
    'clearing'
);

CREATE TYPE code.mailish_folder_info AS (
    path        text,
    uidvalidity bigint
);

CREATE TYPE code.mailish_coordinates AS (
    imap_id     bigint,
    imap_time   timestamp with time zone
);

CREATE TYPE code.mailish_move_coords AS (
    src_imap_id     bigint,
    dst_imap_id     bigint
);

CREATE TYPE code.change_coordinates AS (
    uid     bigint,
    sid     bigint,
    cid     bigint
);

CREATE TYPE code.imap_id_result AS (
    revision bigint,
    imap_id  bigint
);

CREATE TYPE code.collector_id_result AS (
    revision      bigint,
    collector_id  integer
);
