CREATE OR REPLACE FUNCTION code.cast_code_store_attaches_to_mail(
    i_attaches code.store_attach[]
) RETURNS mail.attach[] AS $$
SELECT ARRAY(
    SELECT (a.hid,
            a.type,
            a.filename,
            a.size)::mail.attach
      FROM unnest($1) AS a);
$$ LANGUAGE SQL IMMUTABLE RETURNS NULL ON NULL INPUT;

CREATE CAST
    (code.store_attach[] AS mail.attach[])
 WITH FUNCTION code.cast_code_store_attaches_to_mail(code.store_attach[]);
