CREATE OR REPLACE FUNCTION code.cast_code_store_coordinates_to_impl(
    i_coords code.store_coordinates
) RETURNS impl.store_coordinates AS $$
SELECT (
    $1.fid,
    $1.tid,
    $1.seen,
    $1.deleted,
    $1.st_id,
    $1.received_date,
    $1.size,
    $1.attributes,
    NULL -- no tab by default
)::impl.store_coordinates;
$$ LANGUAGE SQL IMMUTABLE;

CREATE CAST
    (code.store_coordinates AS impl.store_coordinates)
 WITH FUNCTION code.cast_code_store_coordinates_to_impl(code.store_coordinates);


CREATE OR REPLACE FUNCTION code.cast_code_store_coordinates_with_tab_to_impl(
    i_coords code.store_coordinates_with_tab
) RETURNS impl.store_coordinates AS $$
SELECT (
    $1.fid,
    $1.tid,
    $1.seen,
    $1.deleted,
    $1.st_id,
    $1.received_date,
    $1.size,
    $1.attributes,
    $1.tab
)::impl.store_coordinates;
$$ LANGUAGE SQL IMMUTABLE;

CREATE CAST
    (code.store_coordinates_with_tab AS impl.store_coordinates)
 WITH FUNCTION code.cast_code_store_coordinates_with_tab_to_impl(code.store_coordinates_with_tab);

CREATE OR REPLACE FUNCTION code.cast_code_store_deleted_coordinates_to_impl(
    i_coords code.store_deleted_coordinates
) RETURNS impl.store_deleted_coordinates AS $$
SELECT (
    $1.st_id,
    $1.received_date,
    $1.size,
    $1.attributes
)::impl.store_deleted_coordinates;
$$ LANGUAGE SQL IMMUTABLE;

CREATE CAST
    (code.store_deleted_coordinates AS impl.store_deleted_coordinates)
 WITH FUNCTION code.cast_code_store_deleted_coordinates_to_impl(code.store_deleted_coordinates);
