CREATE OR REPLACE FUNCTION code.cast_code_sync_coordinates_to_impl(
    i_subscribed_fid int,
    i_subscribed_tid bigint,
    i_coords         code.sync_coordinates
) RETURNS impl.store_coordinates
AS $$
SELECT (
    i_subscribed_fid,
    i_subscribed_tid,
    i_coords.seen,
    i_coords.deleted,
    i_coords.st_id,
    i_coords.received_date,
    i_coords.size,
    array_append(
        array_remove(
            i_coords.attributes, 'synced'),
        'synced'),
    NULL)::impl.store_coordinates;
$$ LANGUAGE sql IMMUTABLE;