CREATE OR REPLACE FUNCTION code.cast_code_sync_recipients_to_mail(
    code.sync_recipient[]
) RETURNS mail.recipient[]
AS $$
SELECT ARRAY(
    SELECT (type, name, email)::mail.recipient
      FROM unnest($1));
$$ LANGUAGE SQL IMMUTABLE;

CREATE CAST
    (code.sync_recipient[] AS mail.recipient[])
 WITH FUNCTION code.cast_code_sync_recipients_to_mail(code.sync_recipient[]);
