CREATE OR REPLACE FUNCTION code.cast_code_sync_threading_to_impl(
    i_threads code.sync_threading
) RETURNS impl.store_threading
AS $$
SELECT (
    'synced'::mail.threads_merge_rules,
    $1.references_hashes,
    $1.in_reply_to_hash,
    NULL, -- hash_value
    NULL, -- hash_namespace
    NULL, -- hash_uniq_key
    NULL  -- sort_options
)::impl.store_threading;
$$ LANGUAGE SQL IMMUTABLE;

CREATE CAST
    (code.sync_threading AS impl.store_threading)
 WITH FUNCTION code.cast_code_sync_threading_to_impl(code.sync_threading);
