CREATE OR REPLACE FUNCTION code.increment_revision(
    i_uid   bigint
) RETURNS bigint AS $$
DECLARE
    current_revision bigint;
BEGIN
    UPDATE mail.serials
       SET next_revision = next_revision + 1
     WHERE uid = i_uid
    RETURNING next_revision - 1
    INTO current_revision;
    IF NOT found THEN
        RAISE EXCEPTION 'No revision updated, uid: %', i_uid
              USING HINT = 'Probably user doesn''t exists',
                   TABLE = 'mail.serials';
    END IF;
    RETURN current_revision;
END
$$ LANGUAGE plpgsql;
