CREATE TYPE code.create_contacts_user_result AS ENUM (
    'success',
    'already_created',
    'shard_is_occupied_by_user'
);

CREATE TYPE code.new_contacts_email AS (
    contact_id bigint,
    email text,
    type text[],
    label text
);

CREATE TYPE code.new_contact AS (
    list_id bigint,
    format contacts.vcard_format,
    vcard jsonb,
    uri text
);

CREATE TYPE code.updated_contacts_email AS (
    email_id bigint,
    contact_id bigint,
    email text,
    type text[],
    label text
);

CREATE TYPE code.updated_contact AS (
    contact_id bigint,
    list_id bigint,
    format contacts.vcard_format,
    vcard jsonb,
    uri text
);

CREATE TYPE code.create_contacts_list_result AS (
    revision bigint,
    list_id bigint
);

CREATE TYPE code.create_contacts_tag_result AS (
    revision bigint,
    tag_id bigint
);

CREATE TYPE code.create_contacts_result AS (
    revision bigint,
    contact_ids bigint[]
);

CREATE TYPE code.create_contacts_emails_result AS (
    revision bigint,
    email_ids bigint[]
);

CREATE TYPE code.add_contacts_directory_event_result AS ENUM (
    'success',
    'outdated_event'
);

CREATE TYPE code.contacts_email_with_tags AS (
    email_id bigint,
    email text,
    tag_ids bigint[]
);

CREATE TYPE code.directory_entity AS (
    id bigint,
    type contacts.directory_entity_type,
    contact_id bigint
);

CREATE TYPE code.directory_entity_id_and_type AS (
    id bigint,
    type contacts.directory_entity_type
);
