CREATE OR REPLACE FUNCTION code.init_contacts_user (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_check_user_is_here boolean default false
) RETURNS void AS $$
DECLARE
    revision bigint;
    list_id bigint;
    tag_id bigint;
    lists_created bigint;
    tags_created bigint;
BEGIN
    IF i_check_user_is_here AND NOT impl.check_contacts_user_is_here(i_user_id, i_user_type) THEN
        RAISE WARNING 'code.init_contacts_user: user (%, %) is not here', i_user_id, i_user_type;
        RETURN;
    END IF;

    SELECT next_revision, next_list_id, next_tag_id
      FROM impl.acquire_current_contacts_serials(i_user_id := i_user_id, i_user_type := i_user_type)
      INTO revision, list_id, tag_id;

    INSERT INTO contacts.lists (user_id, user_type, list_id, revision, name, type, unique_type)
    SELECT i_user_id, i_user_type, list_id - 1 + row_number() OVER (ORDER BY type) as tag_id, revision, dl.name, dl.type, dl.unique_type
      FROM code.default_contacts_lists() dl;

    GET DIAGNOSTICS lists_created = ROW_COUNT;

    INSERT INTO contacts.tags (user_id, user_type, tag_id, revision, name, type)
    SELECT i_user_id, i_user_type, tag_id - 1 + row_number() OVER (ORDER BY type) as tag_id, revision, dt.name, dt.type
      FROM code.default_contacts_tags() dt;

    GET DIAGNOSTICS tags_created = ROW_COUNT;

    UPDATE contacts.serials
       SET next_list_id = next_list_id + lists_created,
           next_tag_id = next_tag_id + tags_created
     WHERE user_id = i_user_id AND user_type = i_user_type;
END
$$ LANGUAGE plpgsql;
