CREATE OR REPLACE FUNCTION code.add_contacts_directory_event (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_event_id bigint
) RETURNS code.add_contacts_directory_event_result AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    last_event_id bigint;
BEGIN
    SELECT directory_last_event_id
      FROM contacts.users
     WHERE user_id = i_user_id AND user_type = i_user_type AND is_directory_sync_enabled = true
      INTO last_event_id;

    IF NOT FOUND THEN
        UPDATE contacts.users
           SET is_directory_sync_enabled = true,
               directory_last_event_id = i_event_id,
               directory_pending_events_count = 1
         WHERE user_id = i_user_id AND user_type = i_user_type;

        RETURN 'success';
    END IF;

    IF i_event_id <= last_event_id THEN
        RETURN 'outdated_event';
    END IF;

    UPDATE contacts.users
       SET directory_last_event_id = i_event_id,
           directory_pending_events_count = directory_pending_events_count + 1
     WHERE user_id = i_user_id AND user_type = i_user_type;

    RETURN 'success';
END
$$ LANGUAGE plpgsql;
