CREATE OR REPLACE FUNCTION code.complete_sync_contacts_directory_event (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_synced_revision bigint,
    i_synced_event_id bigint
) RETURNS void AS $$
    UPDATE contacts.users
       SET directory_synced_revision = i_synced_revision,
           directory_last_synced_event_id = i_synced_event_id,
           directory_pending_events_count = directory_pending_events_count - 1,
           directory_last_sync_date = now()
     WHERE user_id = i_user_id AND user_type = i_user_type;
$$ LANGUAGE SQL;
