CREATE OR REPLACE FUNCTION code.create_contacts (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_contacts code.new_contact[],
    i_x_request_id text
) RETURNS code.create_contacts_result AS $$
DECLARE
    revision bigint;
    first_contact_id bigint;
    to_create impl.contact[];
BEGIN
    SELECT next_revision, next_contact_id
      FROM impl.acquire_current_contacts_serials(i_user_id := i_user_id, i_user_type := i_user_type)
      INTO revision, first_contact_id;

    SELECT array_agg((first_contact_id + number - 1, list_id, format, vcard, uri)::impl.contact)
      FROM (SELECT *, row_number() OVER () AS number FROM unnest(i_contacts)) t
      INTO to_create;

    PERFORM impl.create_contacts(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_contacts := to_create
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'create_contacts'::contacts.change_type,
        i_arguments := jsonb_build_object('contacts', i_contacts),
        i_changed := jsonb_build_object('contact_ids', (
            SELECT array_agg(contact_id)
              FROM unnest(to_create))
        ),
        i_x_request_id := i_x_request_id
    );

    UPDATE contacts.serials
       SET next_revision = next_revision + 1,
           next_contact_id = next_contact_id + cardinality(to_create)
     WHERE user_id = i_user_id AND user_type = i_user_type;

    RETURN (revision, (
        SELECT array_agg(contact_id)
          FROM unnest(to_create)
    ))::code.create_contacts_result;
END
$$ LANGUAGE plpgsql;
