CREATE OR REPLACE FUNCTION code.create_contacts_directory_entities (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_directory_entities code.directory_entity[],
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
BEGIN
    INSERT INTO contacts.directory_entities (
             user_id,   user_type, directory_entity_id, directory_entity_type,   contact_id, revision
    )
    SELECT i_user_id, i_user_type,                v.id,                v.type, v.contact_id, revision
      FROM unnest(i_directory_entities) AS v;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'create_directory_entities'::contacts.change_type,
        i_arguments := jsonb_build_object('directory_entities', i_directory_entities),
        i_changed := jsonb_build_object(),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
