CREATE OR REPLACE FUNCTION code.create_contacts_emails (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_emails code.new_contacts_email[],
    i_x_request_id text
) RETURNS code.create_contacts_emails_result AS $$
DECLARE
    revision bigint;
    first_email_id bigint;
    new_list_id bigint;
    to_create impl.email[];
BEGIN
    SELECT next_revision, next_email_id
      FROM impl.acquire_current_contacts_serials(i_user_id := i_user_id, i_user_type := i_user_type)
      INTO revision, first_email_id;

    SELECT array_agg((first_email_id + number - 1, contact_id, email, type, label)::impl.email)
      FROM (SELECT *, row_number() OVER () AS number FROM unnest(i_emails)) t
      INTO to_create;

    PERFORM impl.create_contacts_emails(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_emails := to_create
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'create_emails'::contacts.change_type,
        i_arguments := jsonb_build_object('emails', i_emails),
        i_changed := jsonb_build_object('email_ids', (
            SELECT array_agg(email_id)
              FROM unnest(to_create))
        ),
        i_x_request_id := i_x_request_id
    );

    UPDATE contacts.serials
       SET next_revision = next_revision + 1,
           next_email_id = next_email_id + cardinality(to_create)
     WHERE user_id = i_user_id AND user_type = i_user_type;

    RETURN (revision, (
        SELECT array_agg(email_id)
          FROM unnest(to_create)
    ))::code.create_contacts_emails_result;
END
$$ LANGUAGE plpgsql;
