CREATE OR REPLACE FUNCTION code.create_contacts_list(
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_name text,
    i_type contacts.list_type,
    i_x_request_id text
) RETURNS code.create_contacts_list_result AS $$
DECLARE
    revision bigint;
    list_id bigint;
BEGIN
    SELECT next_revision, next_list_id
      FROM impl.acquire_current_contacts_serials(i_user_id := i_user_id, i_user_type := i_user_type)
      INTO revision, list_id;

    INSERT INTO contacts.lists (user_id, user_type, list_id, revision, name, type, unique_type)
    VALUES (i_user_id, i_user_type, list_id, revision, i_name, i_type, code.is_unique_contacts_list_type(i_type));

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'create_list'::contacts.change_type,
        i_arguments := jsonb_build_object('name', i_name, 'type', i_type),
        i_changed := jsonb_build_object('list_id', list_id),
        i_x_request_id := i_x_request_id
    );

    UPDATE contacts.serials
       SET next_revision = next_revision + 1,
           next_list_id = next_list_id + 1
     WHERE user_id = i_user_id AND user_type = i_user_type;

    RETURN (revision, list_id)::code.create_contacts_list_result;
END
$$ LANGUAGE plpgsql;
