CREATE OR REPLACE FUNCTION code.create_contacts_tag (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_name text,
    i_type contacts.tag_type,
    i_x_request_id text
) RETURNS code.create_contacts_tag_result AS $$
DECLARE
    revision bigint;
    tag_id bigint;
BEGIN
    SELECT next_revision, next_tag_id
      FROM impl.acquire_current_contacts_serials(i_user_id := i_user_id, i_user_type := i_user_type)
      INTO revision, tag_id;

    INSERT INTO contacts.tags (user_id, user_type, tag_id, revision, name, type)
    VALUES (i_user_id, i_user_type, tag_id, revision, i_name, i_type);

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'create_tag'::contacts.change_type,
        i_arguments := jsonb_build_object('name', i_name, 'type', i_type),
        i_changed := jsonb_build_object('tag_id', tag_id),
        i_x_request_id := i_x_request_id
    );

    UPDATE contacts.serials
       SET next_revision = next_revision + 1,
           next_tag_id = next_tag_id + 1
     WHERE user_id = i_user_id AND user_type = i_user_type;

    RETURN (revision, tag_id)::code.create_contacts_tag_result;
END
$$ LANGUAGE plpgsql;
