CREATE OR REPLACE FUNCTION code.create_contacts_user (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_x_request_id text
) RETURNS code.create_contacts_user_result AS $$
DECLARE
    v_is_here boolean;
    v_is_deleted boolean;
    revision bigint;
    list_id bigint;
    tag_id bigint;
BEGIN
    SELECT is_here, is_deleted
      FROM contacts.users
     WHERE user_id = i_user_id AND user_type = i_user_type
      INTO v_is_here, v_is_deleted;

    IF FOUND THEN
        IF v_is_here = false THEN
            RETURN 'shard_is_occupied_by_user';
        ELSE
            IF v_is_deleted = false THEN
                RETURN 'already_created';
            END IF;
        END IF;

        PERFORM code.reinit_deleted_contacts_user(i_user_id, i_user_type);
    ElSE
        INSERT INTO contacts.users (user_id, user_type) VALUES (i_user_id, i_user_type);
        INSERT INTO contacts.serials (user_id, user_type) VALUES (i_user_id, i_user_type);
        PERFORM code.init_contacts_user(i_user_id, i_user_type);
    END IF;

    SELECT next_revision, next_list_id, next_tag_id
      FROM impl.acquire_current_contacts_serials(i_user_id, i_user_type)
      INTO revision, list_id, tag_id;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'create_user'::contacts.change_type,
        i_arguments := jsonb_build_object(),
        i_changed := jsonb_build_object(
            'list_ids', (
                SELECT array_agg(t.list_id)
                  FROM (
                    SELECT l.list_id AS list_id
                      FROM contacts.lists AS l
                     WHERE user_id = i_user_id
                       AND user_type = i_user_type
                     ORDER BY l.list_id
                ) AS t
            ),
            'tag_ids', (
                SELECT array_agg(t.tag_id)
                  FROM (
                    SELECT t.tag_id AS tag_id
                      FROM contacts.tags AS t
                     WHERE user_id = i_user_id
                       AND user_type = i_user_type
                     ORDER BY t.tag_id
                ) AS t
            )
        ),
        i_x_request_id := i_x_request_id
    );

    PERFORM impl.increment_contacts_revision(i_user_id, i_user_type);
    RETURN 'success';
END
$$ LANGUAGE plpgsql;
