CREATE OR REPLACE FUNCTION code.delete_contacts(
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_contact_ids bigint[],
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    to_delete impl.contact[];
BEGIN
    SELECT array_agg((contact_id, list_id, format, vcard, uri)::impl.contact) v FROM contacts.contacts c
     WHERE user_id = i_user_id AND user_type = i_user_type AND contact_id IN (SELECT unnest(i_contact_ids))
      INTO to_delete;

    IF to_delete IS NULL OR cardinality(to_delete) = 0 THEN
        RETURN revision - 1;
    END IF;

    PERFORM impl.delete_contacts(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_contact_ids := (
            SELECT array_agg(contact_id)
              FROM unnest(to_delete)
        )
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'delete_contacts'::contacts.change_type,
        i_arguments := jsonb_build_object('contact_ids', i_contact_ids),
        i_changed := jsonb_build_object('contacts', to_delete),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
