CREATE OR REPLACE FUNCTION code.delete_contacts_directory_entities (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_directory_entities code.directory_entity_id_and_type[],
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    deleted_directory_entities code.directory_entity[];
BEGIN
    DELETE FROM contacts.directory_entities
     WHERE user_id = i_user_id
       AND user_type = i_user_type
       AND (directory_entity_id, directory_entity_type)::code.directory_entity_id_and_type = ANY(i_directory_entities);

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'delete_directory_entities'::contacts.change_type,
        i_arguments := jsonb_build_object('directory_entities', i_directory_entities),
        i_changed := jsonb_build_object(),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
