CREATE OR REPLACE FUNCTION code.delete_contacts_emails(
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_email_ids bigint[],
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    to_delete impl.email[];
BEGIN
    SELECT array_agg((email_id, contact_id, email, type, label)::impl.email) v FROM contacts.emails c
     WHERE user_id = i_user_id AND user_type = i_user_type AND email_id IN (SELECT unnest(i_email_ids))
    INTO to_delete;

    IF to_delete IS NULL OR cardinality(to_delete) = 0 THEN
        RETURN revision - 1;
    END IF;

    PERFORM impl.delete_contacts_emails(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_email_ids := (
            SELECT array_agg(email_id)
              FROM unnest(to_delete)
        )
    );

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'delete_emails'::contacts.change_type,
        i_arguments := jsonb_build_object('email_ids', i_email_ids),
        i_changed := jsonb_build_object('emails', to_delete),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
