CREATE OR REPLACE FUNCTION code.delete_contacts_list (
    i_user_id bigint,
    i_user_type contacts.user_type,
    i_list_id bigint,
    i_x_request_id text
) RETURNS bigint AS $$
DECLARE
    revision bigint := impl.acquire_current_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
    list_name text;
    list_type contacts.list_type;
BEGIN
    SELECT name, type
      FROM contacts.lists
     WHERE user_id = i_user_id AND user_type = i_user_type AND list_id = i_list_id
      INTO list_name, list_type;

    IF NOT FOUND THEN
        RETURN revision - 1;
    END IF;

    IF EXISTS (
        SELECT 1
          FROM code.default_contacts_lists()
         WHERE name = list_name AND type = list_type
    ) THEN
        RAISE EXCEPTION 'Delete default list is forbidden'
              USING HINT = 'Delete only not default lists';
    END IF;

    DELETE FROM contacts.lists
     WHERE user_id = i_user_id AND user_type = i_user_type AND list_id = i_list_id;

    PERFORM impl.log_contacts_change(
        i_user_id := i_user_id,
        i_user_type := i_user_type,
        i_revision := revision,
        i_type := 'delete_list'::contacts.change_type,
        i_arguments := jsonb_build_object('list_id', i_list_id),
        i_changed := jsonb_build_object('name', list_name, 'type', list_type),
        i_x_request_id := i_x_request_id
    );

    RETURN impl.increment_contacts_revision(
        i_user_id := i_user_id,
        i_user_type := i_user_type
    );
END
$$ LANGUAGE plpgsql;
